import spacy
from Phyme import Phyme as phyme
import hyphenate
import pronouncing

word = lambda i: "".join([k for k in i if k.isalpha()]).lower()
nlp = spacy.load("en_core_web_lg")

ph  = phyme()

def endSlantRhyme(x, x1_ind, x2_ind):
    word1 = "".join([i for i in x[x1_ind].split()[-1] if i.isalpha()])
    word2 = "".join([i for i in x[x2_ind].split()[-1] if i.isalpha()])
    #print(word1, word2)
    rhyme_types = [ph.get_family_rhymes, ph.get_partner_rhymes, ph.get_perfect_rhymes, ph.get_substitution_rhymes]
    try:
        for rhyme_type in rhyme_types:
            if any([word1 in k for k in rhyme_type(word2).values()]):
                return True
    except:
        return False
    return False

def endrhyme(x, x1_ind, x2_ind):
    word1 = "".join([i for i in x[x1_ind].split()[-1] if i.isalpha()])
    word2 = "".join([i for i in x[x2_ind].split()[-1] if i.isalpha()])
    return word1 in pronouncing.rhymes(word2)

def sameStartWord(x, x1_ind, x2_ind):
    return word(x[x1_ind].split(" ")[0].lower()) in x[x2_ind].lower() or word(x[x2_ind].split(" ")[0].lower()) in x[x1_ind].lower()

def containsSameNonStopWord(x, x1_ind, x2_ind):
    x1_toks = set([k for k in [token for token in nlp(x[x1_ind])] if not k.is_stop and not k.is_punct])
    x2_toks = set([k for k in [token for token in nlp(x[x2_ind])] if not k.is_stop and not k.is_punct])
    return len(x1_toks.union(x2_toks)) > 0

def containsTwoSimilarWords(x, x1_ind, x2_ind):
    tot_sim = 0
    c = 0.4
    x1_toks = set([k for k in [token for token in nlp(x[x1_ind])] if not k.is_stop and not k.is_punct])
    x2_toks = set([k for k in [token for token in nlp(x[x2_ind])] if not k.is_stop and not k.is_punct])
    for val in x1_toks:
        for val2 in x2_toks:
            if val.similarity(val2) > c:
                tot_sim += 1
                if tot_sim == 2:
                    return True
    return False

def possSameMeter(x, x1_ind, x2_ind):
    x1_len = sum([len(hyphenate.hyphenate_word(i)) for i in x[x1_ind].split(" ")])
    x2_len = sum([len(hyphenate.hyphenate_word(i)) for i in x[x2_ind].split(" ")])
    return abs(x1_len - x2_len) <= 2



def sameEndWord(x, x1_ind, x2_ind):
    return word(x[x1_ind].split(" ")[-1].lower()) in x[x2_ind].lower() or word(x[x2_ind].split(" ")[-1].lower()) in x[x1_ind].lower()